#include <stdio.h>

unsigned char vsrom[256];
FILE *ROM;
FILE *OUT;
int main()
{
int i,snbit;

// change this to 32 and add another line below the hex to add AppleNet address
#define SIZE 16

unsigned char magic_serialnumber[SIZE+1]= 
   {0xff,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
 //   00   01   02   03   04   05   06   07   08   09   10   11   12   13   14   15

// VSROM is 256 bytes, serial is 16 bytes, applenet is also another 16 bytes after

#define RESET (1)
#define VSYNC (2)
#define BIT2  (4)
#define BIT3  (8)
#define CSYNC (16)
#define VSIR  (32)
#define HSYNC (64)
#define SERNO (128)

ROM=fopen("vidstate.rom","rb");
OUT=fopen("magicsnvidstate.rom","wb");
i=fread(vsrom,256,1,ROM);

for (i=0; i<256; i++)
 {
 
  // extract serial number bit from array, if we go over, leave what's in the ROM (i.e. AppleNet)
  if ( (i/8) < SIZE )
     snbit=(magic_serialnumber[i / 8] & (1<<( i & 7) ) ) ? 1:0;
     //                                     ^^^^^^^^- not sure about this, endianness might need to reverse this
     //                                     but since the magic sn is either 00 or ff shouldn't matter.
     //                                     if it does, replace with (7-(i&7))
  else
     snbit=(vsrom[i] & SERNO) ? 1:0;

  // replace serial number bit  
  vsrom[i]=vsrom[i] & (255^SERNO);

  printf("%3d:%02x RST:%d VSYNC:%d CSYNC:%d VSIR:%d HSYNC:%d SERNO:%d 2:%d 3:%d\n",i,vsrom[i],
   (vsrom[i] & RESET) ? 1:0,
   (vsrom[i] & VSYNC) ? 1:0,
   (vsrom[i] & CSYNC) ? 1:0,
   (vsrom[i] & VSIR ) ? 1:0,
   (vsrom[i] & HSYNC) ? 1:0,
   (vsrom[i] & SERNO) ? 1:0,
   (vsrom[i] & BIT2 ) ? 1:0,
   (vsrom[i] & BIT3 ) ? 1:0   );
 

 }
i=fwrite(vsrom,256,1,OUT);
fclose(ROM);
fclose(OUT);

}